package ga.core.algorithm.interactive;

import ga.core.GA;
import ga.core.evaluation.EvaluationListener;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.IMutationOp;
import ga.core.individual.IIndividual;
import ga.core.individual.population.IPopulation;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;

/**
 * Interface for simple interactive genetic algorithms.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface ISIGA<T extends IIndividual<T>> extends EvaluationListener<T>,
    GA<T> {

  /**
   * Getter for the crossover operator.
   * 
   * @return Crossover operator.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public abstract ICrossoverOp<T> getCrossoverOp();

  /**
   * Getter for the mutation operator.
   * 
   * @return Mutation operator.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public abstract IMutationOp<T> getMutationOp();

  @Override
  public abstract void init();

  @Override
  public abstract void newIndividualRequested();

  @Override
  public abstract void individualEvaluated(final T individual);

  @Override
  public abstract void setValidate(final boolean validate);

  @Override
  public abstract void setValidator(final IValidator<T> validator);

  @Override
  public abstract IPopulation<T> getPopulation();

  /**
   * Getter for the GA context.
   * 
   * @return The GA context.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public abstract GAContext getContext();

  /**
   * Exits the algorithm and frees resources.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public abstract void exit();

  /**
   * Getter for the current generation. Note: in steady state mode, this is the
   * actual number of single reproductions.
   * 
   * @return Current generation.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public abstract int getGeneration();
}
